<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
  <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
  <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
  <xsl:param name="xslConvertToCY" select="cif:xslConvertToCY"/>
  <!-- Variable to hold cubic factor -->
  <xsl:variable name="cubicFactor">
    <xsl:choose>
      <xsl:when test="//@linearUnits = 'Imperial'">
        <xsl:choose>
          <xsl:when test="$xslConvertToCY = 1">27</xsl:when>
          <xsl:otherwise>1</xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>1</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <!-- Volumes Report -->
  <xsl:template match="/">
    <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
    <html>
      <head>
        <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
        <!-- Title displayed in browser Title Bar -->
        <title lang="en">Výpis kubatur</title>
      </head>
      <body>
        <xsl:choose>
          <xsl:when test="$xslShowHelp = 'true'">
            <xsl:call-template name="StyleSheetHelp"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:for-each select="InRoads">
              <center>
                <!-- Report Title -->
                <h2 lang="en">Výpis kubatur</h2>
                <p lang="en">
                  Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                  Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                </p>
              </center>
              <!-- Cross Section Set Data -->
              <xsl:for-each select="CrossSectionSet">
                <table class="margin" cellpadding="2" width="90%">
                  <tbody>
                    <tr>
                      <th align="right" lang="en">Název sady příčných řezů:&#xa0; </th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="@setName"/>
                      </td>
                    </tr>
                    <tr>
                      <th align="right" lang="en">Název trasy:&#xa0; </th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="@alignmentName"/>
                      </td>
                    </tr>
                    <tr>
                      <th align="right" lang="en" style="font-size: 80%">Koeficient Vstupní rastr:&#xa0; </th>
                      <td align="left" style="font-size: 80%">
                        <xsl:value-of select="../@inputGridScaleFactor" />
                      </td>
                      <td align="right" lang="en" style="font-size: 80%">
                        <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                        <xsl:if test="//@linearUnits = 'Imperial'">
                          <xsl:choose>
                            <xsl:when test="$xslConvertToCY = 1">
                              ve stopách, čtverečních stopách a yardech krychlových,
                            </xsl:when>
                            <xsl:otherwise>
                              ve stopách, čtverečních stopách a stopách krychlových,
                            </xsl:otherwise>
                          </xsl:choose>
                        </xsl:if>
                        <xsl:if test="//@linearUnits = 'Metric'">
                          v metrech, metrech čtverečních a metrech krychlových,
                        </xsl:if>
                        pokud není specifikováno jinak.
                      </td>
                    </tr>
                  </tbody>
                </table>
                <hr/>
                <!-- Volume Data -->
                <table class="margin" width="90%">
                  <xsl:for-each select="CrossSectionStations">
                    <thead style="display:table-header-group">
                      <tr>
                        <th class="underline" lang="en" valign="bottom">Staničení</th>
                        <th class="underline" lang="en" valign="bottom">Typ</th>
                        <th class="underline" lang="en" valign="bottom">Plocha</th>
                        <th class="underline" lang="en" valign="bottom">Objem</th>
                        <th class="underline" lang="en" valign="bottom">Koeficient</th>
                        <th class="underline" lang="en" valign="bottom">
                          Vyrovnaný<br/>objem
                        </th>
                        <th class="underline" lang="en" valign="bottom">
                          Zahrnout do <br/>pořadnice hmoty?
                        </th>
                        <th class="underline" lang="en" valign="bottom">
                          Pořadnice hmoty<br/>
                        </th>
                      </tr>
                    </thead>
                    <xsl:for-each select="CrossSectionStation">
                      <tbody>
                        <xsl:apply-templates/>
                      </tbody>
                      <tfoot style="display:table-footer-group">
                        <xsl:if test="position() = last()">
                          <xsl:for-each select="StationVolume">
                            <tr>
                              <td colspan="8">
                                <hr/>
                              </td>
                            </tr>
                            <tr>
                              <th align="left">Celkem:</th>
                            </tr>
                            <xsl:apply-templates mode="final"/>
                          </xsl:for-each>
                        </xsl:if>
                      </tfoot>
                    </xsl:for-each>
                  </xsl:for-each>
                </table>
              </xsl:for-each>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="StationVolume">
    <tr>
      <th align="left" nowrap="nowrap">
        <xsl:value-of select="cif:stationFormat(number(../Station/@externalStation), string(../Station/@externalStationName))"/>
      </th>
      <td colspan="6">&#xa0;</td>
      <td align="right">
        <xsl:value-of select="cif:cubicFormat(number(@massOrdinate div $cubicFactor))"/>
      </td>
    </tr>
    <xsl:apply-templates mode="normalParent"/>
    <tr>
      <td>&#xa0;</td>
    </tr>
  </xsl:template>
  <xsl:template match="Material" mode="normalParent">
    <xsl:choose>
      <xsl:when test="Replaced">
        <tr style="line-height:25%">
          <td colspan="8">&#xa0;</td>
        </tr>
        <tr>
          <td align="right" colspan="2" lang="en">
            <xsl:value-of select="@name"/> (nahrazeno):&#xa0;
          </td>
          <td align="right">
            <xsl:value-of select="cif:areaFormat(number(Replaced/@area))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:cubicFormat(number(Replaced/@volume div $cubicFactor))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:distanceFormat(number(Replaced/@factor))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:cubicFormat(number(Replaced/@adjustedVolume div $cubicFactor))"/>
          </td>
          <xsl:choose>
            <xsl:when test="Replaced/@includeInMassOrdinate = 'true'">
              <td align="center" lang="en">Ano</td>
            </xsl:when>
            <xsl:otherwise>
              <td align="center" lang="en">Ne</td>
            </xsl:otherwise>
          </xsl:choose>
        </tr>
        <tr>
          <td align="right" colspan="2" lang="en">
            <xsl:value-of select="@name"/> (nenahrazeno):&#xa0;
          </td>
          <td align="right">
            <xsl:value-of select="cif:areaFormat(number(NotReplaced/@area))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:cubicFormat(number(NotReplaced/@volume div $cubicFactor))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:distanceFormat(number(NotReplaced/@factor))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:cubicFormat(number(NotReplaced/@adjustedVolume div $cubicFactor))"/>
          </td>
          <xsl:choose>
            <xsl:when test="NotReplaced/@includeInMassOrdinate = 'true'">
              <td align="center" lang="en">Anp</td>
            </xsl:when>
            <xsl:otherwise>
              <td align="center" lang="en">Ne</td>
            </xsl:otherwise>
          </xsl:choose>
        </tr>
        <tr>
          <td align="right" colspan="2" lang="en">
            Total <xsl:value-of select="@name"/>:&#xa0;
          </td>
          <td class="overline" align="right">
            <xsl:value-of select="cif:areaFormat(number(@area))"/>
          </td>
          <td class="overline" align="right">
            <xsl:value-of select="cif:cubicFormat(number(@volume div $cubicFactor))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:distanceFormat(number(@factor))"/>
          </td>
          <td class="overline" align="right">
            <xsl:value-of select="cif:cubicFormat(number(@adjustedVolume div $cubicFactor))"/>
          </td>
        </tr>
        <tr style="line-height:25%">
          <td colspan="8">&#xa0;</td>
        </tr>
      </xsl:when>
      <xsl:when test="number(@area) > 0 or number(@cumulativeVolume) > 0">
        <tr>
          <td align="right" colspan="2">
            <xsl:value-of select="@name"/>:&#xa0;
          </td>
          <td align="right">
            <xsl:value-of select="cif:areaFormat(number(@area))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:cubicFormat(number(@volume div $cubicFactor))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:distanceFormat(number(@factor))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:cubicFormat(number(@adjustedVolume div $cubicFactor))"/>
          </td>
          <xsl:choose>
            <xsl:when test="@includeInMassOrdinate = 'true'">
              <td align="center" lang="en">Ano</td>
            </xsl:when>
            <xsl:otherwise>
              <td align="center" lang="en">Ne</td>
            </xsl:otherwise>
          </xsl:choose>
        </tr>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="Material" mode="final">
    <xsl:choose>
      <xsl:when test="Replaced">
        <tr style="line-height:25%">
          <td colspan="8">&#xa0;</td>
        </tr>
        <tr>
          <td align="right" colspan="2" lang="en">
            <xsl:value-of select="@name"/> (nahrazeno):&#xa0;
          </td>
          <td>&#xa0;</td>
          <td align="right">
            <xsl:value-of select="cif:cubicFormat(number(Replaced/@cumulativeVolume div $cubicFactor))"/>
          </td>
          <td>&#xa0;</td>
          <td align="right">
            <xsl:value-of select="cif:cubicFormat(number(Replaced/@cumulativeAdjustedVolume div $cubicFactor))"/>
          </td>
          <xsl:choose>
            <xsl:when test="Replaced/@includeInMassOrdinate = 'true'">
              <td align="center" lang="en">Ano</td>
            </xsl:when>
            <xsl:otherwise>
              <td align="center" lang="en">Ne</td>
            </xsl:otherwise>
          </xsl:choose>
        </tr>
        <tr>
          <td align="right" colspan="2" lang="en">
            <xsl:value-of select="@name"/> (nenahrazeno):&#xa0;
          </td>
          <td>&#xa0;</td>
          <td align="right">
            <xsl:value-of select="cif:cubicFormat(number(NotReplaced/@cumulativeVolume div $cubicFactor))"/>
          </td>
          <td>&#xa0;</td>
          <td align="right">
            <xsl:value-of select="cif:cubicFormat(number(NotReplaced/@cumulativeAdjustedVolume div $cubicFactor))"/>
          </td>
          <xsl:choose>
            <xsl:when test="NotReplaced/@includeInMassOrdinate = 'true'">
              <td align="center" lang="en">Ano</td>
            </xsl:when>
            <xsl:otherwise>
              <td align="center" lang="en">Ne</td>
            </xsl:otherwise>
          </xsl:choose>
        </tr>
        <tr>
          <td align="right" colspan="2" lang="en">
            Celkem <xsl:value-of select="@name"/>:&#xa0;
          </td>
          <td>&#xa0;</td>
          <td align="right">
            <xsl:value-of select="cif:cubicFormat(number(@cumulativeVolume div $cubicFactor))"/>
          </td>
          <td>&#xa0;</td>
          <td align="right">
            <xsl:value-of select="cif:cubicFormat(number(@cumulativeAdjustedVolume div $cubicFactor))"/>
          </td>
        </tr>
        <tr style="line-height:25%">
          <td colspan="8">&#xa0;</td>
        </tr>
      </xsl:when>
      <xsl:when test="number(@area) > 0 or number(@cumulativeVolume) > 0">
        <tr>
          <td align="right" colspan="2">
            <xsl:value-of select="@name"/>:&#xa0;
          </td>
          <td>&#xa0;</td>
          <td align="right">
            <xsl:value-of select="cif:cubicFormat(number(@cumulativeVolume div $cubicFactor))"/>
          </td>
          <td>&#xa0;</td>
          <td align="right">
            <xsl:value-of select="cif:cubicFormat(number(@cumulativeAdjustedVolume div $cubicFactor))"/>
          </td>
          <xsl:choose>
            <xsl:when test="@includeInMassOrdinate = 'true'">
              <td align="center" lang="en">Ano</td>
            </xsl:when>
            <xsl:otherwise>
              <td align="center" lang="en">Ne</td>
            </xsl:otherwise>
          </xsl:choose>
        </tr>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="StyleSheetHelp">
    <div class="section1">
      <h4 lang="en">Poznámky</h4>
      <p class="normal1" lang="en">
        Musíte vytvořit příčné řezy podél trasy a sada příčných řezů musí
        obsahovat povrchy a prvky, nad kterými chcete provádět výpis.
      </p>
      <p class="normal1" lang="en">
        Soubor dat XML můžete vytvořit příkazem Kubatura z příčných řezů v 
          Vyhodnocení &gt; Příčné řezy &gt; Příčné řezy se zapnutým parametrem
          Vytvořit XML výpis  v záložce Obecně nebo příkazem Vyhodnocení &gt;
          Příčné řezy &gt; Výpis příčných řezů se zapnutým parametrem Včetně objemu v záložce Hlavní.
      </p>
      <p class="small" lang="en">
        <em>&#xa9; 2006 Bentley Systems, Inc</em>
      </p>
    </div>
  </xsl:template>
</xsl:stylesheet>
